//+------------------------------------------------------------------+
//|                                                  ONNX Test       |
//|                                                   Copyright 2023 |
//|                                               Your Name Here     |
//+------------------------------------------------------------------+
#property copyright   "Copyright 2023, Your Name Here"
#property link        "https://www.mql5.com"
#property version     "1.00"

static vectorf ExtOutputData(1);
vectorf output_data(1);

#include <Trade\Trade.mqh>
CTrade trade;

#resource "\\LSTM\\data_processing_pipeline.onnx" as uchar ExtModel[]

#define SAMPLE_SIZE 160  // Adjusted to match the model's expected input size

long     ExtHandle=INVALID_HANDLE;
datetime ExtNextBar=0;

// Expert Advisor initialization
int OnInit()
{
   // Load the ONNX model
   ExtHandle = OnnxCreateFromBuffer(ExtModel, ONNX_DEFAULT);
   if (ExtHandle == INVALID_HANDLE)
   {
      Print("Error creating model OnnxCreateFromBuffer ", GetLastError());
      return(INIT_FAILED);
   }

   // Set input shape
   const long input_shape[] = {SAMPLE_SIZE, 5};  // Adjust based on your model's input dimensions
   if (!OnnxSetInputShape(ExtHandle, ONNX_DEFAULT, input_shape))
   {
      Print("Error setting the input shape OnnxSetInputShape ", GetLastError());
      return(INIT_FAILED);
   }

   // Set output shape
   const long output_shape[] = {SAMPLE_SIZE, 5};  // Adjust based on your model's output dimensions
   if (!OnnxSetOutputShape(ExtHandle, 0, output_shape))
   {
      Print("Error setting the output shape OnnxSetOutputShape ", GetLastError());
      return(INIT_FAILED);
   }

   return(INIT_SUCCEEDED);
}

// Expert Advisor deinitialization
void OnDeinit(const int reason)
{
   if (ExtHandle != INVALID_HANDLE)
   {
      OnnxRelease(ExtHandle);
      ExtHandle = INVALID_HANDLE;
   }
}

// Process the tick function
void OnTick()
{
   if (TimeCurrent() < ExtNextBar)
      return;

   ExtNextBar = TimeCurrent();
   ExtNextBar -= ExtNextBar % PeriodSeconds();
   ExtNextBar += PeriodSeconds();

   // Fetch new data and run the ONNX model
   if (!ProcessData())
   {
      Print("Error processing data");
      return;
   }
}

// Function to process data using the ONNX model
bool ProcessData()
{
   MqlRates rates[SAMPLE_SIZE];
   int copied = CopyRates(_Symbol, PERIOD_M15, 1, SAMPLE_SIZE, rates);
   if (copied != SAMPLE_SIZE)
   {
      Print("Failed to copy the expected number of rates. Expected: ", SAMPLE_SIZE, ", Copied: ", copied);
      return false;
   }
   else if(copied == SAMPLE_SIZE)
   {
      Print("Successfully copied the expected number of rates. Expected: ", SAMPLE_SIZE, ", Copied: ", copied);
   }

   double min_time = rates[0].time;
   double max_time = rates[0].time;
   for (int i = 1; i < copied; i++)
   {
      if (rates[i].time < min_time)
         min_time = rates[i].time;
      if (rates[i].time > max_time)
         max_time = rates[i].time;
   }

   float input_data[SAMPLE_SIZE * 5];
   int count;
   for (int i = 0; i < copied; i++)
   {
      count++; 
      // Normalize time to be between 0 and 1 within a day
      input_data[i * 5 + 0] = (float)((rates[i].time));  // normalized time
      input_data[i * 5 + 1] = (float)rates[i].open;  // open
      input_data[i * 5 + 2] = (float)rates[i].high;  // high
      input_data[i * 5 + 3] = (float)rates[i].low;   // low
      input_data[i * 5 + 4] = (float)rates[i].close; // close
   }
   Print("Count of copied after for loop: ", count);
   // Resize input vector to match the copied data size
   vectorf input_vector;
   input_vector.Resize(copied * 5);
   for (int i = 0; i < copied * 5; i++)
   {
      input_vector[i] = input_data[i];
   }

   vectorf output_vector;
   output_vector.Resize(copied * 5);

   if (!OnnxRun(ExtHandle, ONNX_NO_CONVERSION, input_vector, output_vector))
   {
      Print("Error running the ONNX model: ", GetLastError());
      return false;
   }

   // Process the output data as needed
   for (int i = 0; i < copied; i++)
   {
      float time_token = output_vector[i * 5 + 0];
      float norm_open = output_vector[i * 5 + 1];
      float norm_high = output_vector[i * 5 + 2];
      float norm_low = output_vector[i * 5 + 3];
      float norm_close = output_vector[i * 5 + 4];

      // Print the processed data
      PrintFormat("Time Token: %f, Norm Open: %f, Norm High: %f, Norm Low: %f, Norm Close: %f",
                  time_token, norm_open, norm_high, norm_low, norm_close);
   }

   return true;
}
